using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Deployment.Application;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace ClickOnce1
{
   public partial class Form1 : Form
   {
      private ApplicationDeployment ad = null;

      public Form1()
      {
         InitializeComponent();
         ad = ApplicationDeployment.CurrentDeployment;
         ad.CheckForUpdateCompleted +=
            new CheckForUpdateCompletedEventHandler(ad_CheckForUpdateCompleted);
         ad.UpdateProgressChanged +=
            new DeploymentProgressChangedEventHandler(ad_UpdateProgressChanged);
         ad.CheckForUpdateProgressChanged +=
            new DeploymentProgressChangedEventHandler(ad_CheckForUpdateProgressChanged);
         ad.UpdateCompleted += new AsyncCompletedEventHandler(ad_UpdateCompleted);
         this.Text = "ClickOnce Application (v" + ad.CurrentVersion.ToString() + ")";
      }

      void ad_UpdateProgressChanged(object sender, DeploymentProgressChangedEventArgs e)
      {
         tsProgress.Value = e.ProgressPercentage;
         tsProgress.Visible = true;
      }

      void ad_CheckForUpdateProgressChanged(object sender,
         DeploymentProgressChangedEventArgs e)
      {
         tsProgress.Value = e.ProgressPercentage;
         tsProgress.Visible = true;
      }

      void ad_UpdateCompleted(object sender, AsyncCompletedEventArgs e)
      {
         if (e.Error != null)
         {
            MessageBox.Show("Wystpi bd podczas aktualizacji aplikacji:\n" +
               e.Error.ToString());
            return;
         }

         if (MessageBox.Show(
            "Aktualizacja zakoczona powodzeniem.\nCzy chcesz teraz ponownie uruchomi aplikacj?",
            "Restart aplikacji", MessageBoxButtons.YesNo) == DialogResult.Yes)
         {
            Application.Restart();
         }
      }

      void ad_CheckForUpdateCompleted(object sender, CheckForUpdateCompletedEventArgs e)
      {
         if (e.Error != null)
         {
            MessageBox.Show("Wystpi bd podczas sprawdzania dostpnoci aktualizacji: \n" +
               e.Error.ToString());
            return;
         }

         if (e.UpdateAvailable)
         {
            tsLabel.Text = "Znaleziono aktualizacj!";
            tsProgress.Value = 0;
            if (e.IsUpdateRequired)
            {
               MessageBox.Show(
                  "Dostpna jest obowizkowa aktualizacja. Rozpocznie si natychmiastowa aktualizacja.");
               ad.UpdateAsync();
            }
            else
            {
               if (MessageBox.Show("Dostpna jest opcjonalna aktualizacja. Czy chcesz pobra j teraz?",
                  "Dostpna aktualizacja", MessageBoxButtons.YesNo) == DialogResult.Yes)
               {
                  ad.UpdateAsync();
               }
            }
         }
         else
         {
            tsLabel.Text = "Aplikacja ClickOnce";
            tsProgress.Value = 0;
            MessageBox.Show("Nie ma w tej chwili dostpnych nowych aktualizacji dla tej aplikacji.");
         }
      }

      private void aboutToolStripMenuItem_Click_1(object sender, EventArgs e)
      {
         FormLibrary.AboutBox1 aBox = new FormLibrary.AboutBox1();
         aBox.ShowDialog();
      }

      private void aktualizujToolStripMenuItem_Click(object sender, EventArgs e)
      {
         // jeli ta aplikacja jest aplikacj ClickOnce
         if (ApplicationDeployment.IsNetworkDeployed)
         {
            ad.CheckForUpdateAsync();
            tsLabel.Text = "Kontrola aktualizacji...";
            tsProgress.Value = 0;
         }
      }
   }
}
